
/*****************************************************************/
/* This program takes a file name as the input argument.         */
/* It sorts the lines in the file and print them to stdout in    */
/* the sorted order.                                             */
/*****************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <locale.h>
#include <wchar.h>
#define LINESIZE 10
#define MAXLINE 20

int compare();

main(int argc, char *argv[]) {

        char mbs[MAXLINE][LINESIZE+1]; /* array to store the lines of the input
                                          file. */
        FILE *ifp;
        int i, lines;


       (void) setlocale(LC_ALL, "");

       if (argc < 2) 
         {
	  printf("Usage: %s filename \n", argv[0]);
          exit (-1);
         }

       ifp = fopen(argv[1], "r");
       if (ifp == NULL)
	  printf("Could not open the input file. \n");


        /* Loop to read in one line at at time until end of file is reached.
           the lines are stored in mbs[] */

	for (i=0; i<MAXLINE; i++)
       		{  
        	if ( fgets(mbs[i], 20, ifp) == NULL ) break;
		}

        lines = i; /* the total number of lines. */

                     /* call qsort to sort the mbs[] array. "i" is the
                        number of elements in the array, "LINESIZE+1" is
                        the size of the element, and compare is the 
                        function for qsort to use for comparison. */
        qsort(mbs, i, LINESIZE+1, compare);
                                            

        /* print out the sorted lines. */
        for (i=0; i<lines; i++)
          printf("%s", mbs[i]);
    }

compare(a,b)
char a[LINESIZE+1];
char b[LINESIZE+1];
{
return strcoll(a, b); /* call strcoll() to compare the two elements. */
}
